# 自连接

现有 node 表如下：

```sql
create table node(
    id int primary key auto_increment,
    pid int,
    content varchar(256)
)
```

现在Joe 想要给出 content 以 `fork-` 开头的所有节点，和它们的子节点，输出 `parent_id, parent_content, child_id, child_content` 。
他应该怎么做？

<hr/>

点击进入[MySQL实战练习环境](https://mydev.csdn.net/product/pod/new?image=cimg-centos7-skilltreemysql&connect=auto&create=auto&utm_source=skill){target="_blank"}。

* `show databases;` 列出所有数据库
* `show tables;` 列出所有表

## 答案

```sql
select l.id as parent_id, 
       l.content as parent_content,
       r.id as child_id,
       r.content as child_content
from node as l
    join node as r on l.id = r.pid
where l.content like 'fork-%';
```

## 选项

### A

```sql
select l.id as parent_id, 
       l.content as parent_content,
       r.id as child_id,
       r.content as child_content
from node as l
    right join node as r on l.id = r.pid
where l.content like 'fork-%';
```

### B

```sql
select l.id as parent_id, 
       l.content as parent_content,
       r.id as child_id,
       r.content as child_content
from node as l,  node as r 
where l.id =(+) r.pid l.content like 'fork-%';
```

### C

```sql
select l.id as parent_id, 
       l.content as parent_content,
       r.id as child_id,
       r.content as child_content
from node as l
    cross join node as r on l.id = r.pid
where l.content like 'fork-%';
```

### D

```sql
select l.id as parent_id, 
       l.content as parent_content,
       r.id as child_id,
       r.content as child_content
from node as l
    join node as r on l.pid = r.id
where l.content like 'fork-%';
```